package cn.com.duiba.kjy.api.remoteservice.animation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.animation.AnimationContentDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.animation.AnimationParams;

/**
 * @author lizhi
 * @date 2019/8/24 2:56 PM
 */
@AdvancedFeignClient
public interface RemoteAnimationService {

    /**
     * 新增或更新预览动画
     * @param dto 预览动画信息
     * @return 动画唯一标识
     */
    Long saveOrUpdatePreview(AnimationContentDto dto);

    /**
     * 发布动画
     * @param appId 动画唯一标识
     * @return true-成功，false-失败
     */
    boolean publish(Long appId);

    /**
     * 复制预览动画
     * @param appId 动画唯一标识
     * @return 复制后的预览动画唯一标识
     */
    Long copyPreview(Long appId);

    /**
     * 查询正式动画详情
     * @param appId 动画唯一标识
     * @return 正式动画详情
     */
    AnimationContentDto selectProduceDetail(Long appId);

    /**
     * 删除预览动画
     * @param appId 动画唯一标识
     * @return 删除条数
     */
    int removePreview(Long appId);

    /**
     * 分页查询预览动画列表
     * @param params 参数
     * @return 预览动画列表
     */
    Page<AnimationContentDto> selectPreviewPage(AnimationParams params);

    /**
     * 查询预览动画详情
     * @param appId 动画唯一标识
     * @return 预览动画详情
     */
    AnimationContentDto selectPreviewDetail(Long appId);

    /**
     * 获取预览token
     * @param appId 动画唯一标识
     * @return 预览token
     */
    String getPreviewToken(Long appId);

    /**
     * 根据预览token获取动画唯一标识
     * @param token 预览token
     * @return 动画唯一标识
     */
    Long getAppIdByPreviewToken(String token);
}
