package cn.com.duiba.kjy.api.dto.order;

import cn.com.duiba.kjy.api.enums.order.WithdrawStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 提现订单
*/
@Data
public class WithdrawalOrderDto implements Serializable {

    private static final long serialVersionUID = -530985641092802587L;

    /**
    * 提现订单号
    */
    private Long orderNo;

    /**
    * 业务方id
    */
    private String bizId;

    /**
     * 销售员ID
     */
    private Long sellerId;

    /**
    * 用户的标识，对当前公众号唯一
    */
    private String openId;

    /**
    * 渠道返回的交易流水号
    */
    private String paymentNo;

    /**
    * 0创建提现 1提现中 2提现成功 3提现失败
     * @see WithdrawStatusEnum
    */
    private Integer withdrawStatus;

    /**
    * 提现金额大于0，单位为分
    */
    private Integer amount;

    /**
    * 提现时额外的渠道信息
    */
    private String extra;

    /**
    * 提现描述
    */
    private String description;

    /**
    * 提现失败后渠道方返回的错误码
    */
    private String failureCode;

    /**
    * 提现失败后渠道方返回的错误描述
    */
    private String failureMsg;

    /**
     * 访客用户Id
     */
    private Long visitorId;

    /**
     * 活动类型  1:代理人余额提现 2:2019双十一红包提现
     */
    private Integer activityType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}

