package cn.com.duiba.kjy.api.enums.fission;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author : liuchao1@duiba.com.cn
 * @date 2019年11月07日 16:18
 * @version V1.0
 **/
public enum FissionAwardContextTemplateEnum {

    RECEIVE_AWARD(1,"领奖消息模板"),

    ASSISTANCE(2, "助力消息模板"),

    ;

    private Integer value;
    private String text;

    FissionAwardContextTemplateEnum(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    private static final Map<Integer, FissionAwardContextTemplateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(FissionAwardContextTemplateEnum templateEnum : values()){
            ENUM_MAP.put(templateEnum.getValue(), templateEnum);
        }
    }

    public static FissionAwardContextTemplateEnum getByValue(Integer value) {
        if (value == null) {
            return null;
        }
        return ENUM_MAP.get(value);
    }

    public Integer getValue() {
        return value;
    }

    public String getText() {
        return text;
    }
}
