package cn.com.duiba.kjy.api.params.redpacket;

import cn.com.duiba.kjy.api.enums.redpacket.RedPacketBizTypeEnum;
import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author lizhi
 * @date 2020/1/7 3:31 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SellerRedPacketConfParam extends PageQuery {

    private static final long serialVersionUID = 2047171456568768633L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 红包对应的业务id
     */
    private Long redPacketBizId;

    /**
     * 红包对应的业务类型
     * @see RedPacketBizTypeEnum
     */
    private Integer redPacketBizType;

    /**
     * 客集集订单号
     */
    private String bizOrderNo;

    /**
     * 支付状态
     * @see cn.com.duiba.kjy.api.enums.pay.ChargeStatusEnum
     */
    private Integer chargeStatus;

    /**
     * 支付状态集合
     */
    private List<Integer> chargeStatusList;

    /**
     * 退款状态
     * @see cn.com.duiba.kjy.api.enums.pay.RefundStatusEnum
     */
    private Integer refundStatus;

    /**
     * 优惠id，对应tb_seller_promotion.id
     */
    private Long promotionId;

}
