package cn.com.duiba.kjy.api.enums.user;

import java.util.Objects;

/**
 * 用户访问路径枚举
 * @author 吴文哲
 * @date 2020-02-25 14:54
 **/
public enum UserVisitPathEnum {

    UNKNOW(0,"未知",""),
    PERSONAL(1,"个人","singlemessage"),
    GROUP(2,"群","groupmessage"),
    FRIENDS_GROUP(3,"朋友圈","timeline"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    /**
     * 来源
     */
    private String from;

    UserVisitPathEnum(Integer type,String desc,String from){
        this.type = type;
        this.desc = desc;
        this.from = from;
    }

    public static UserVisitPathEnum getByFrom(String from) {
        for (UserVisitPathEnum enumVal : UserVisitPathEnum.values()) {
            if (Objects.equals(from,enumVal.getFrom())) {
                return enumVal;
            }
        }
        return null;
    }


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getFrom() {
        return from;
    }
}
