package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerExtDto;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerExtEditParam;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019/7/1 16:15
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerExtService {


    /**
     * 根据代理人id和客户用户id查询
     * @param sellerId
     * @param userId
     * @return
     */
    List<SellerCustomerExtDto> listBySellerIdAndUserId(Long sellerId, Long userId);


    /**
     * 新增或更新客户信息
     * @param param
     * @return
     */
    Integer saveOrUpdateCustomerExt(SellerCustomerExtEditParam param);


    /**
     * 根据代理人id 用户id 自定义id代码查询
     * @param sellerId
     * @param userId
     * @param fieldIds
     * @return
     */
    Map<String, SellerCustomerExtDto> getMapBySellerIdAndUserIdAndFieldIds(Long sellerId, Long userId, List<Long> fieldIds);

}
