package cn.com.duiba.kjy.api.remoteservice.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.config.SellerConfigDto;

import java.util.List;

/**
 * 代理人配置
 * @author 吴文哲
 * @date 2019-11-19 15:19
 **/
@AdvancedFeignClient
public interface RemoteSellerConfigService {

    /**
     * 更新代理人配置
     * @param sellerConfigDto
     * @return
     */
    Integer addOrUpdateSellerConfig(SellerConfigDto sellerConfigDto);

    /**
     * 获取代理人配置列表
     * @param sellerId
     * @return
     */
    List<SellerConfigDto> getSellerConfigList(Long sellerId,List<String> keyList);

    /**
     * 批量更新代理人配置
     * @param sellerConfigDtos
     * @param sellerId
     * @return
     */
    Integer addOrUpdateSellerConfigList(Long sellerId,List<SellerConfigDto> sellerConfigDtos);

}
