package cn.com.duiba.kjy.api.dto.sellercard;

import cn.com.duiba.kjy.api.util.NumberUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * Created by dugq on 2019-07-29.
 * 客户用例 仅用于接收参数
 */
@Data
public class CaseDto implements Serializable {
    private static final long serialVersionUID = 3750043947685268067L;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * HBase key
     */
    private String id;

    /**
     * 客户姓名
     */
    private String name;

    /**
     * "0:男 1:女",
     */
    private Integer sex;

    /**
     * 客户年龄
     */
    private Integer age;

    /**
     * 客户年收入
     */
    @Deprecated
    private String yearIncome;

    /**
     * 案例类型(投保险种)
     */
    @Deprecated
    private String caseType;

    /**
     * 保费
     */
    @Deprecated
    private String premium;

    /**
     * 权益
     */
    @Deprecated
    private String assets;

    /**
     * 案例描述
     */
    private String caseIntro;

    /**
     * 案例图片
     */
    private String casePics;

    /**
     * 购买产品
     */
    private String product;

    /**
     * 用户版本
     *
     * @see cn.com.duiba.kjy.api.enums.version.UserVersionEnum
     */
    private Integer userVersion;

    /**
     * 必填项是否完善
     */
    private boolean compelete;

    /**
     * 是否完善了客户案例
     *
     * @return
     */
    public boolean isCompelete() {
        //拥有版本信息  就表示为新版本
        if(NumberUtil.isNotNullOrLteZero(userVersion)){
            return compelete;
        }
        //保险版 数据是否完善判断
        if (StringUtils.isBlank(this.name)) {
            return false;
        }
        if (StringUtils.isBlank(this.caseType)) {
            return false;
        }
        if (StringUtils.isBlank(this.premium)) {
            return false;
        }
        if (StringUtils.isBlank(this.assets)) {
            return false;
        }
        if (StringUtils.isBlank(this.caseIntro)) {
            return false;
        }

        return true;
    }

}
