package cn.com.duiba.kjy.api.dto.sellercard;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 通用版 客户案例
 *
 * @author 吴文哲
 * @date 2020-02-26 18:51
 **/
@Data
public class CaseDto4CommonVersion extends CaseDto implements Serializable {
    private static final long serialVersionUID = 3571934804731481844L;


    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * HBase key
     */
    private String id;

    /**
     * 客户姓名
     */
    private String name;

    /**
     * 购买产品
     */
    private String product;

    /**
     * 案例描述
     */
    private String caseIntro;

    /**
     * 案例图片
     */
    private String casePics;

    /**
     * 必填项是否完善
     */
    private boolean compelete;


    public void setCompelete() {
        if (StringUtils.isBlank(this.name) || StringUtils.isBlank(this.product) || StringUtils.isBlank(this.casePics)|| StringUtils.isBlank(this.caseIntro)) {
            this.compelete = false;
        }
        this.compelete = true;
    }


}
