package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ContentDto;
import cn.com.duiba.kjy.api.dto.SellerContentDto;
import cn.com.duiba.kjy.api.dto.SellerContentSimpleDto;
import cn.com.duiba.kjy.api.dto.SellerDto;
import cn.com.duiba.kjy.api.dto.content.SellerVideoDto;
import cn.com.duiba.kjy.api.dto.whosawme.ContentSellerBo;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SellerContentParams;
import cn.com.duiba.kjy.api.params.video.VideoSearchParams;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteSellerContentService {

    /**
     * 文章阅读次数加1, 销售员文章阅读次数加1
     * @param contentId 内容ID
     * @param scId 销售员文章ID
     * @return
     */
    Boolean readNumIncrease(Long contentId, Long scId);

    /**
     * 活动参与人数加1
     * @param sellerId
     * @param activityId
     * @return
     */
    Boolean formNumIncrease(Long sellerId, Long activityId);

    /**
     * 根据销售员ID查询内容
     *
     * @param id 销售员文章ID
     * @return
     */
    SellerContentDto findById(Long id);

    /**
     * 根据销售员ID查询内容
     *
     * @param id 销售员文章ID
     * @return
     */
    SellerContentSimpleDto findSimpleById(Long id);

    /**
     * 显示隐藏我的名片
     *
     * @param scId
     * @param showCard
     * @return
     */
    Boolean showCard(Long scId, Integer showCard);

    /**
     * 生成文章落地页记录
     *
     * @param sellerContentDto
     * @return
     */
    Long getScId(SellerContentDto sellerContentDto);

    /**
     * 分页获取销售发布的文章列表
     *
     * @param sellerContentParams
     * @return
     */
    Page<SellerContentSimpleDto> contentList(SellerContentParams sellerContentParams);

    /**
     * 更新首次访问
     * @param scid
     * @return
     */
    Boolean updateNotFirstVisit(Long scid);

    /**
     * 获取销售员文章的阅读数
     * @param sellerId 销售员ID
     * @param contentIds 销售员内容ID集合
     * @return 内容对应的阅读数
     */
    Map<Long, Long> findReadNumBySellerId(Long sellerId, List<Long> contentIds);


    /**
     * 获取一段时间内代理人分享的文章数
     * @param sellerId
     * @param startDate
     * @param endDate
     * @return
     */
    Integer getContentNumBySellerIdAndTime(Long sellerId, Date startDate, Date endDate);

    SellerContentSimpleDto selectOne(Long id);

    /**
     * 根据scId 获取内容详情 包括 文章,活动,早报,晚报,名片,自定义链接,腰封,周报
     * @param scIds
     * @return
     */
    List<ContentSellerBo> getContentListByScIds(List<Long> scIds);

    /**
     * 判断当前活动是否未中奖活动
     * @param contentIds
     * @return map的value不能为null  不是true就是false
     */
    Map<Long,Boolean> isLottery(List<Long> contentIds);

    /**
     * 判断当前活动是否为填写资料  看活动关联的自定义字段表是否有数据
     * @param contentIds
     * @return map的value不能为null  不是true就是false
     */
    Map<Long,Boolean>  isMaterial(List<Long> contentIds);

    /**
     * 判断当前文章/早报/晚报 是否为答题  是否关联tb_content_interaction_question.content_id字段,且表中的类型interaction_type 是0或1
     * @param contentIds
     * @return map的value不能为null  不是true就是false
     */
    Map<Long, Boolean> isOption(List<Long> contentIds);

    /**
     * 判断当前文章/早报/晚报 是否为答题  是否关联tb_content_interaction_question.content_id字段,且表中的类型interaction_type 是2或3
     * @param contentIds
     * @return map的value不能为null  不是true就是false
     */
    Map<Long, Boolean> isVote(List<Long> contentIds);

    /**
     * 根据条件找到简单的sellerContent对象
     * @param param
     * @return
     */
    List<SellerContentSimpleDto> findByCondition(SellerContentParams param);

    /**
     * 查询视频
     * @param param
     * @return
     */
    List<SellerVideoDto> selectVideoList(VideoSearchParams param);

    Long selectVideoListCount(VideoSearchParams param);

    /**
     * 根据条件查询scid
     * @param sellerId
     * @param contentId
     * @param contentType
     * @return
     */
    Long findScIdBysIdCidType(Long sellerId,Long contentId,String contentType);


    /**
     * 标记素材为自定义
     * @param scid
     * @return
     */
    Integer updateCustomContentType(Long scid, Integer customContentType);
}
