package cn.com.duiba.kjy.api.remoteservice.accurate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.accurate.AccurateCompanyDto;
import cn.com.duiba.kjy.api.dto.accurate.AccurateUsrDto;
import cn.com.duiba.kjy.api.params.accurate.AccurateAddParam;

import java.util.List;

/**
 * @author xiaotian
 */
@AdvancedFeignClient
public interface RemoteAccurateService {

    /**
     * 获取销售精准素材详情
     * @param sid
     * @return
     */
    AccurateUsrDto getdetail(Long sid);

    /**
     * 更新或者增加精准素材详情
     * @param accurateUsrDto
     */
    void updateOrAdd(AccurateUsrDto accurateUsrDto);


    /**
     * 更新公司ID
     * @param sid
     * @param companyId
     */
    void updateCompanyId(Long sid,Long companyId);


    /**
     * 更新喜好标签
     * @param sid
     * @param tag
     */
    void updateTag(Long sid, String tag);


    /**
     * 获取精准素材公司列表
     * @return
     */
    List<AccurateCompanyDto> getCompanyList();


    /**
     * 手动给文章打标签（管理端没有上之前）
     * @param contentId
     * @param tag1
     * @param tag2
     * @param companyId
     * @return
     */
    boolean tagContent(Long contentId,Long tag1,Long tag2,String companyId) throws KjyCenterException;


    /**
     * 管理端给内容打标签
     * @param accurateAddParam
     * @return
     */
    boolean tagContentForBack(AccurateAddParam accurateAddParam) throws KjyCenterException;

    /**
     * 获取当前用户的精准排行榜
     * @param sid
     * @return
     */
    List<Long>  getRankList(Long sid);


    /**
     * 获取当前用户的精准排行榜(V2)
     * @param sid
     * @return
     */
    List<Long>  getRankListV2(Long sid);

    /**
     * 根据公司id查询列表
     * @param companyIds
     * @return
     */
    List<AccurateCompanyDto> getCompanyByIds(List<Long> companyIds);


    /**
     * 新增公司
     * @param accurateCompanyDto
     * @return
     */
    int add(AccurateCompanyDto accurateCompanyDto);
}
