package cn.com.duiba.kjy.api.remoteservice.grabmaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialContentExtDto;
import cn.com.duiba.kjy.api.dto.grabmaterial.MaterialContentListDto;
import cn.com.duiba.kjy.api.params.grabmaterial.MaterialContentListParam;

import java.util.List;

/**
 * 发圈素材
 *
 * @Author chentiecheng
 * @Date 2020/3/9 3:45 下午
 */
@AdvancedFeignClient
public interface RemoteMaterialContentService {
    /**
     * 获取发圈素材列表
     * @param param
     * @return
     */
    List<MaterialContentListDto> selectList(MaterialContentListParam param);

    /**
     * 统计发圈素材总数
     * @param param
     * @return
     */
    Long countList(MaterialContentListParam param);

    /**
     * 新增编辑发圈素材
     * @param dto
     * @return
     */
    Boolean insertOrUpdateMaterialContent(MaterialContentExtDto dto);

    /**
     * 根据id查详情
     * @param id
     * @return
     */
    MaterialContentExtDto getInfoById(Long id);

    /**
     * 根据id删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

}
