/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.interaction;

import cn.com.duiba.kjy.api.enums.interaction.InteractionSelectionTypeEnum;
import cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateTypeEnum;
import java.util.HashMap;
import java.util.Map;

public enum InteractionTypeEnum {
    OPTION_SINGLE((byte)0, "\u95ee\u7b54\u9898\u5355\u9009"),
    OPTION_MULTI((byte)1, "\u95ee\u7b54\u9898\u591a\u9009"),
    VOTE_PK((byte)2, "\u6295\u7968pk"),
    VOTE_SINGLE((byte)3, "\u6295\u7968\u5355\u9009"),
    VOTE_MULTI((byte)4, "\u6295\u7968\u591a\u9009");

    private Byte type;
    private String desc;
    private static final Map<Byte, InteractionTypeEnum> ENUM_MAP;

    private InteractionTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isOption(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == OPTION_SINGLE || typeEnum == OPTION_MULTI;
    }

    public static boolean isVote(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == VOTE_PK || typeEnum == VOTE_SINGLE || typeEnum == VOTE_MULTI;
    }

    public static boolean isMultiple(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == OPTION_MULTI || typeEnum == VOTE_MULTI;
    }

    public static boolean isSingle(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == OPTION_SINGLE || typeEnum == VOTE_PK || typeEnum == VOTE_SINGLE;
    }

    public static InteractionTypeEnum getByType(Byte type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static InteractionTypeEnum convert2InteractionTypeEnum(InteractionTemplateTypeEnum typeEnum, InteractionSelectionTypeEnum selectionTypeEnum) {
        if (typeEnum == null) {
            return null;
        }
        if (selectionTypeEnum == null) {
            return null;
        }
        if (typeEnum == InteractionTemplateTypeEnum.VOTE && selectionTypeEnum == InteractionSelectionTypeEnum.SINGLE) {
            return VOTE_SINGLE;
        }
        if (typeEnum == InteractionTemplateTypeEnum.VOTE && selectionTypeEnum == InteractionSelectionTypeEnum.MULTIPLE) {
            return VOTE_MULTI;
        }
        if (typeEnum == InteractionTemplateTypeEnum.OPTION && selectionTypeEnum == InteractionSelectionTypeEnum.SINGLE) {
            return OPTION_SINGLE;
        }
        if (typeEnum == InteractionTemplateTypeEnum.OPTION && selectionTypeEnum == InteractionSelectionTypeEnum.MULTIPLE) {
            return OPTION_MULTI;
        }
        return null;
    }

    static {
        ENUM_MAP = new HashMap<Byte, InteractionTypeEnum>();
        for (InteractionTypeEnum typeEnum : InteractionTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }
}

