package cn.com.duiba.kjy.api.dto.sellercard;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 保险专业版客户案例
 *
 * @author 吴文哲
 * @date 2020-02-27 10:49
 **/
@Data
public class CaseDto4InsuranceVersion implements Serializable {

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * HBase key
     */
    private String id;

    /**
     * 客户姓名
     */
    private String name;

    /**
     * "0:男 1:女",
     */
    @Deprecated
    private Integer sex;

    /**
     * 客户年龄
     */
    private Integer age;

    /**
     * 客户年收入
     */
    @Deprecated
    private String yearIncome;

    /**
     * 案例类型(投保险种)
     */
    @Deprecated
    private String caseType;

    /**
     * 保费
     */
    @Deprecated
    private String premium;

    /**
     * 权益
     */
    @Deprecated
    private String assets;

    /**
     * 案例描述
     */
    private String caseIntro;

    /**
     * 案例图片
     */
    private String casePics;

    /**
     * 购买产品
     */
    private String product;

    /**
     * 职业
     */
    private String job;

    /**
     * 必填项是否完善
     */
    private boolean complete;


    public void setComplete() {
        if (StringUtils.isBlank(this.name) || StringUtils.isBlank(this.product) ||
                StringUtils.isBlank(this.caseIntro)|| StringUtils.isBlank(this.casePics) ) {
            this.complete = false;
        }
        this.complete = true;
    }

    /**
     * 用户版本
     *
     * @see cn.com.duiba.kjy.api.enums.version.UserVersionEnum
     */
    private Integer userVersion;
}
