package cn.com.duiba.kjy.api.enums.content;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-12-23 14:16
 * @description:
 */
public enum HeadlineTypeEnum {

    /**
     * 早报类型：1 本地头条，2 热门头条
     */
    LOCAL_HEADLINE(1, "本地头条"),
    HOT_HEADLINE(2, "热门头条"),

    ;
    private Integer code;

    private String desc;

    HeadlineTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * 通过code获取枚举
     * @param code
     * @return
     */
    public static HeadlineTypeEnum getByCode(Integer code) {
        if (Objects.isNull(code)){
            return null;
        }
        for (HeadlineTypeEnum enumVal : HeadlineTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
