package cn.com.duiba.kjy.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.activity.statistics.LotteryOrderStatisticsDto;
import cn.com.duiba.kjy.api.dto.lottery.LotteryOrderDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.lottery.LotteryOrderParams;

/**
 * @author lizhi
 * @date 2019/10/23 3:51 PM
 */
@AdvancedFeignClient
public interface RemoteLotteryOrderService {

    /**
     * 插入
     * @param dto 参数
     * @return 主键
     */
    Long insert(LotteryOrderDto dto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 订单信息
     */
    LotteryOrderDto findById(Long id);

    /**
     * 分页查询参与次数
     * @param params 分页参数
     * @return 列表
     */
    Page<LotteryOrderStatisticsDto> findVisitorCountPage(LotteryOrderParams params);
}
