package cn.com.duiba.kjy.api.dto.explosionContent;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 种草素材内资源位关联表
 * @author kjj mybatis generator 
 * 2020-05-21
 */
@Data
public class ExplosionContentResourceDto implements Serializable {
    private static final long serialVersionUID = 15900304162626402L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *对应tb_content.id
     * not null default = null
     */
    private Long contentId;

    /**
     *
     *资源类型 1=投票 2=产品链接 3=风险评测 4=FAQ 5=理赔案例 6=词条
     * not null default = null
     */
    private Integer resourceType;

    /**
     *
     *资源类型对应的id
     * not null default = null
     */
    private Long resourceId;

    /**
     *
     *资源类型关联的其他ids
     * max length = 255
     */
    private String resRelationIds;

    /**
     *
     *资源搭配文案
     * max length = 255
     */
    private String resourceIntro;

    /**
     *
     * 标题
     * max length = 190
     * not null default = 
     */
    private String title;

    /**
     *
     * 副标题
     * max length = 190
     * not null default = 
     */
    private String subTitle;

    /**
     *
     *是否删除，1=已删除
     * not null default = 0
     */
    private Integer deleted;

    /**
     *
     *创建日期
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改日期
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}