package cn.com.duiba.kjy.api.dto.process;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 审批流程表
 * @author kjj mybatis generator 
 * 2020-04-30
 */
@Data
public class ProcessFlowDto implements Serializable {
    private static final long serialVersionUID = 1588213763984641L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *流程类型：1:线下采购打款流程
     * not null default = null
     */
    private Integer flowType;

    /**
     *
     *tb_serial_pay_record.id  打款记录ID
     * not null default = null
     */
    private Long outId;

    /**
     *
     *审批流程进度 1:第一个审批 2:第二个审批
     * not null default = null
     */
    private Integer flowGrade;

    /**
     *
     *角色类型 1:销售主管 2:财务
     * not null default = null
     */
    private Long checkerRoleType;

    /**
     *
     *审批人ID
     */
    private Long checkId;

    /**
     *
     *审批人名称
     * max length = 45
     */
    private String checkName;

    /**
     *
     *审批说明
     * max length = 200
     */
    private String checkRemark;

    /**
     *
     *审批状态 0:待审批 1:审批通过 2:审批拒绝
     * not null default = 0
     */
    private Integer checkStatus;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}