package cn.com.duiba.kjy.api.params.content;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 分类素材查询参数
 * @author 吴文哲
 * @date 2020-05-07 14:27
 **/
@Data
public class ContentClassifySearchParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -6354723986908996734L;

    /**
     * 一级标签列表
     */
    private List<Long> firstTagIds;

    /**
     * 二级标签列表
     */
    private List<Long> secondTagIds;

    /**
     * 三级标签列表
     */
    private List<Long> thirdTagIds;

    /**
     * 素材类型
     */
    private String contentType;

    /**
     * 素材标题  分词查询
     */
    private String title;

    /**
     * 素材状态
     * @see cn.com.duiba.kjy.api.constant.ContentStatusEnum
     */
    private Integer contentState;

    /**
     * 筛选发布时间（开始）
     */
    private Date startReleaseTime;

    /**
     * 筛选发布时间（结束）
     */
    private Date endReleaseTime;




}
