package cn.com.duiba.kjy.api.remoteservice.explosioncontent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.explosionContent.ExplosionContentResourceDto;
import cn.com.duiba.kjy.api.params.explosionContent.ExplosionResourceAddParam;
import cn.com.duiba.kjy.api.params.interaction.InteractionParams;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2020-05-20 17:26
 * @descript 种草素材内容资源remoteService
 */
@AdvancedFeignClient
public interface RemoteExplosionContentResourceService {

    /**
     * 根据id查询详情(包含查询已删除的)
     * @param id
     * @return
     */
    ExplosionContentResourceDto selectById(Long id);

    /**
     * 根据ids查询列表
     * @param ids
     * @return
     */
    List<ExplosionContentResourceDto> listByIds(List<Long> ids);

    /**
     * 插入交互信息
     * @param param
     * @return
     */
    Long saveOrUpdateBasic(ExplosionResourceAddParam param);

    /**
     * 添加投票
     * @param interactionParams
     * @return
     */
    Long addOrUpdateInteraction(InteractionParams interactionParams) throws KjyCenterException;

    /**
     * 删除种草素材资源位
     * @param id 资源位id，tb_explosion_content_resource 表主键
     * @return
     */
    Boolean deleteById(Long id);
}
