package cn.com.duiba.kjy.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.lottery.KjjCouponDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.lottery.KjjCouponParams;

import java.util.List;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/10/26 3:58 PM
 */
@AdvancedFeignClient
public interface RemoteKjjCouponService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 优惠券
     */
    KjjCouponDto findById(Long id);

    /**
     * 分页查询
     * @param params 参数
     * @return 优惠券列表
     */
    Page<KjjCouponDto> selectPage(KjjCouponParams params);

    /**
     * 编辑库存
     * @param id 主键
     * @param totalStock 总库存
     * @return true-成功，false-失败
     */
    boolean editStock(Long id, int totalStock);

    /**
     * 新增或更新
     * @param dto 优惠券信息
     * @return 主键
     */
    Long saveOrUpdate(KjjCouponDto dto);

    /**
     * 更新状态
     * @param id 主键
     * @param state 状态
     * @return 执行结果
     */
    int updateState(Long id, Integer state);

    /**
     * 在给定ID中查询关闭状态的优惠券
     * @param ids 主键集合
     * @return 关闭状态优惠券ID集合
     */
    List<Long> findCloseIds(List<Long> ids);

    /**
     * 根据主键集合查询剩余库存
     * @param ids 主键集合
     * @return 剩余库存map，key-主键，value-剩余库存
     */
    Map<Long, Integer> findRemainingStockByIds(List<Long> ids);
}
