package cn.com.duiba.kjy.api.util;

import lombok.extern.slf4j.Slf4j;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

import static cn.com.duiba.wolf.utils.DateUtils.getDayDate;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2020/3/11 13:52
 * @Description:
 */
@Slf4j
public class DateUtil {
    /**
     * 获取 当前年、半年、季度、月、日、小时 开始结束时间
     */
    public static final SimpleDateFormat longHourSdf = new SimpleDateFormat("yyyy-MM-dd HH");;

    public static Date getCurrentHourStartTime(Date now) {
        if(Objects.isNull(now)){
            now = new Date();
        }
        try {
            now = longHourSdf.parse(longHourSdf.format(now));
        } catch (Exception e) {
            log.warn("获取时间有误",e);
        }
        return now;
    }

    /**
     * 判断date 是否在 start 和 end之间 ( )
     *
     * @param date 被比较的时间
     * @param start 开始时间
     * @param end 结束时间
     * @return
     */
    public static boolean isDateBetween(Date date, Date start, Date end) {
        if (Objects.isNull(date) || Objects.isNull(start) || Objects.isNull(end)) {
            return false;
        }
        if (date.getTime() > end.getTime() || date.getTime() < start.getTime()) {
            return false;
        }
        return true;
    }

    /**
     * 判断 date是否在time之前 不包含边界
     *
     * @param date
     * @param time
     * @return
     */
    public static boolean isDateBefore(Date date, Date time) {
        if (Objects.isNull(date) || Objects.isNull(time)) {
            return false;
        }
        if (date.getTime() < time.getTime()) {
            return true;
        }
        return false;
    }
    /**
     * 判断 date是否在time之后 不包含边界
     *
     * @param date
     * @param time
     * @return
     */
    public static boolean isDateAfter(Date date, Date time) {
        if (Objects.isNull(date) || Objects.isNull(time)) {
            return false;
        }
        if (date.getTime() > time.getTime()) {
            return true;
        }
        return false;
    }

    /**
     * 根据LocalDateTime获取date
     * @param localDateTime
     * @return
     */
    public static Date covertToDate(LocalDateTime localDateTime){
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }


    /**
     * 加年
     * @param date
     * @param offset
     * @return
     */
    public static Date yearAddOrSub(Date date, int offset) {
        if (date == null){
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.get(Calendar.YEAR);
        cal.set(Calendar.YEAR, cal.get(Calendar.YEAR) + offset);
        return cal.getTime();
    }

    /**
     * 根据日期 获取本周一日期
     * 跟DateUtils的getMondayDate 不同的是，该方法只会获取本周一，不会获取到上周一
     */
    public static Date getMondayDate(Date day) {
        Calendar calWeek = Calendar.getInstance();
        calWeek.setTime(day);
        if (Calendar.SUNDAY == calWeek.get(Calendar.DAY_OF_WEEK)) {
            calWeek.add(Calendar.DATE, -6);
        } else if (Calendar.TUESDAY == calWeek.get(Calendar.DAY_OF_WEEK)) {
            calWeek.add(Calendar.DATE, -1);
        } else if (Calendar.WEDNESDAY == calWeek.get(Calendar.DAY_OF_WEEK)) {
            calWeek.add(Calendar.DATE, -2);
        } else if (Calendar.THURSDAY == calWeek.get(Calendar.DAY_OF_WEEK)) {
            calWeek.add(Calendar.DATE, -3);
        } else if (Calendar.FRIDAY == calWeek.get(Calendar.DAY_OF_WEEK)) {
            calWeek.add(Calendar.DATE, -4);
        } else if (Calendar.SATURDAY == calWeek.get(Calendar.DAY_OF_WEEK)) {
            calWeek.add(Calendar.DATE, -5);
        }
        return getDayDate(calWeek.getTime());
    }

}
