package cn.com.duiba.kjy.api.dto.distribution;

import cn.com.duiba.kjy.api.enums.seller.DistributionSourceTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 *
 * @author zhanghuifeng
 * date 2019-07-23-15:16
 */
@Data
public class DistributionRecordDto implements Serializable {
    private static final long serialVersionUID = -5179354352640405958L;

    /**
     * 被邀请销售员ID(tb_seller)
     */
    private Long sellerId;

    /**
     * 上级销售员ID(tb_seller)
     */
    private Long parentSid;

    /**
     * 来源类型，1:直属；2:引流
     * @see DistributionSourceTypeEnum
     */
    private Integer sourceType;

    /**
     * 分销类型
     * @see cn.com.duiba.kjy.api.enums.seller.DistributionTypeEnum
     */
    private Integer distributionType;
}
