package cn.com.duiba.kjy.api.dto.greeting;

import cn.com.duiba.kjy.api.enums.greeting.BlessImageStateEnum;
import lombok.Data;
import java.io.Serializable;

/**
 * 贺卡扩展信息
 * @author lizhi
 * @date 2019/12/18 10:58 AM
 */
@Data
public class ContentGreetingCardExtDto implements Serializable {

    private static final long serialVersionUID = 6488379246549064941L;

    /**
     * 贺卡ID，对应tb_content.id
     */
    private Long contentId;

    /**
     * 贺卡链接
     */
    private String cardUrl;

    /**
     * 贺卡默认祝福语
     */
    private String blessWord;

    /**
     * 贺卡默认祝福语字数限制
     */
    private Integer wordLimit;

    /**
     * 小程序配文
     */
    private String mpShareDocument;

    /**
     * 小程序配图
     */
    private String mpImageUrl;

    /**
     * 备注
     */
    private String remark;

    /**
     * 答谢图片,以英文逗号分隔
     */
    private String thanksImgUrl;

    /**
     * 分享海报底图
     */
    private String posterUrl;

    /**
     * 祝福语图片开关
     * @see BlessImageStateEnum
     */
    private Integer blessImageState;

    /**
     * 红包分享文案
     */
    private String redPacketShareMsg;

    /**
     * 红包分享图片
     */
    private String redPacketShareImg;

    /**
     * 默认话术语
     */
    private String spareTalking;

    /**
     * 红包祝福语
     */
    private String redPacketBlessWord;

    /**
     * 海报开关 1:开 2:关
     */
    private Integer posterSwitch;

    /**
     * 默认贺卡海报图
     */
    private String posterDefaultImgUrl;

    /**
     * 红包贺卡海报图
     */
    private String posterRedPacketImgUrl;

    /**
     * 礼物贺卡海报图
     */
    private String posterGiftImgUrl;

    /**
     * 贺卡类型
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingTypeEnum
     */
    private Integer greetingType;

    /**
     * 贺卡开关10进制数
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingSwitchEnum
     */
    private Integer greetingSwitch;

    /**
     * 标签
     */
    private String tags;

    /**
     * 祝福语开关
     */
    private Integer blessWordSwitch;

    /**
     * 红包祝福语开关
     */
    private Integer redPacketBlessSwitch;

    /**
     * 访客署名开关
     */
    private Integer visitorSignatureSwitch;

    /**
     * 公司名称编辑开关
     */
    private Integer companyNameSwitch;

    /**
     * 感谢类型
     * @see cn.com.duiba.kjy.api.enums.greeting.GreetingThanksTypeEnum
     */
    private Integer thanksType;
}
