package cn.com.duiba.kjy.api.dto.seller;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 代理人素材最后转发记录
 * @author kjj mybatis generator
 * 2020-06-22
 */
@Data
public class SellerLastForwardDto implements Serializable {

    private static final long serialVersionUID = 15928078868188881L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 转发人id 对应tb_users中id
     */
    private Long userId;

    /**
     * 内容id 对应tb_content中id
     */
    private Long contentId;

    /**
     * 代理人内容id 对应tb_seller_content中id
     */
    private Long scid;

    /**
     * 代理人id 对应tb_seller中id
     */
    private Long sellerId;

    /**
     * 销售员转发途径 0:未知 1:个人/微信群 2:朋友圈
     */
    private Integer forwardType;

    /**
     * 内容类型：对应tb_content.content_type
     */
    private String contentType;

    /**
     * 最后一次转发时间
     */
    private Date lastForwardTime;

}
