package cn.com.duiba.kjy.api.dto.sellerGift;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 销售奖励发放记录表
 * @author kjj mybatis generator 
 * 2020-06-19
 */
@Data
public class SellerGiftDetailDto implements Serializable {
    private static final long serialVersionUID = 15925348335043945L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *批次ID：tb_seller_batch.id
     * not null default = null
     */
    private Long giftBatchId;

    /**
     *
     *用户ID
     */
    private Long sellerId;

    /**
     *
     *用户手机号
     * max length = 20
     * not null default = null
     */
    private String sellerPhone;

    /**
     *
     *用户微信昵称（输入）
     * max length = 45
     */
    private String wechatName;

    /**
     *
     *vip奖励时长 1:天 2:月 3:年
     */
    private Integer vipDurationType;

    /**
     *
     *时长数量
     */
    private Integer vipDurationCount;

    /**
     *
     *奖励类型：1:vip时长
     */
    private Integer giftType;

    /**
     *
     *验证状态 0:未通过 1:通过
     * not null default = 0
     */
    private Integer checkStatus;

    /**
     *
     *奖励发放状态 ：0:待发放 1:已发放
     */
    private Integer giftStatus;

    /**
     *
     *用户版本
     */
    private Integer userVersion;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}