package cn.com.duiba.kjy.api.dto.weeklystats;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 代理人周报内容访问统计
 * @author kjj mybatis generator 
 * 2020-07-13
 */
@Data
public class WeeklyContentStatsDto implements Serializable {
    private static final long serialVersionUID = 15946077242717033L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *销售id，对应tb_sellers.id
     * not null default = null
     */
    private Long sellerId;

    /**
     *
     *周开始时间
     * not null default = null
     */
    private Date startDate;

    /**
     *
     *周结束时间
     * not null default = null
     */
    private Date endDate;

    /**
     *
     * 内容id,contentType=2时id对应问答表id，其他类型对应tb_content.id
     */
    private Long sourceId;

    /**
     * 内容类型
     * @see cn.com.duiba.kjy.api.enums.weekly.ContentStatsTypeEnum
     */
    private Integer contentType;
    /**
     *
     *来访数
     * not null default = 0
     */
    private Integer visitCount;

    /**
     *
     *总线索数
     * not null default = 0
     */
    private Integer clueCount;

    /**
     *
     *素材转发人数
     * not null default = 0
     */
    private Integer forwardCount;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}