package cn.com.duiba.kjy.api.enums.process;

import java.util.HashMap;
import java.util.Map;

/**
 * 审批流程角色类型枚举
 * @author xiaotian
 * @date 2020/1/7 3:43 PM
 */
public enum ProcessTypeEnum {

    /**
     * 企业采购打款审批流程
     */
    SERIAL_CHECK(1,"企业采购打款审批"),

    /**
     * 用户退款审批
     */
    REFUND_CHECK(2,"用户退款审批")
    ;

    private Integer code;
    private String desc;

    ProcessTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static final Map<Integer, ProcessTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(ProcessTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static ProcessTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }



}
