package cn.com.duiba.kjy.api.enums.seller;

import java.util.Objects;

/**
 * 销售员展示二维码类型
 * @author lizhi
 * @date 2019/7/10 5:46 PM
 */
public enum SellerShowQrCodeTypeEnum {

    OWN_QR_CODE(1, "展示销售员个人二维码"),
    OA_QR_CODE(2, "展示平台公众号二维码"),
    ;

    private Integer type;

    private String desc;

    SellerShowQrCodeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SellerShowQrCodeTypeEnum getByType(Integer type) {
        if (Objects.isNull(type)) {
            return null;
        }
        for (SellerShowQrCodeTypeEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
