package cn.com.duiba.kjy.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.user.UserForwardDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.user.UserForwardQryParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019/6/29 18:01
 * @descript
 */
@AdvancedFeignClient
public interface RemoteUserForwardService {

    /**
     * 根据代理人id和访客Id查询转发数
     * @param sellerId
     * @param userId
     * @return
     */
    Integer countForwardNumBySellerIdAndUserId(Long sellerId, Long userId);


    /**
     * 查询转发列表
     * @param param
     * @return
     */
    Integer countByParams(UserForwardQryParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<UserForwardDto> getForwardPage(UserForwardQryParam param);

    /**
     * 根据条件查询转发记录
     * @param param
     * @return
     */
    List<UserForwardDto> getForwardByCondition(UserForwardQryParam param);
    /**
     * 保存转发记录
     * @param scId
     * @param userId
     * @return
     */
    @Deprecated
    Boolean saveUserForward(Long scId, Long userId, Long visitId);

    /**
     * 转发记录 同时保存转发类型
     * @param scId
     * @param userId
     * @param visitId
     * @return
     */
    Boolean saveUserForwardWithType(Long scId, Long userId, Long visitId,Integer forwardType);

    /**
     * 转发记录 并返回tb_user_forward 表的主键
     * 目前仅代理人演示数据用到
     * @return
     */
    Long saveUserForward4SellerDemo(UserForwardDto userForwardDto);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    UserForwardDto getUserForwardDtoById(Long id);

    /**
     * 获取转发列表
     * @return
     */
    Map<Long, List<Long>> getForwarMapByScIds(List<Long> scIds);


    List<UserForwardDto> getForwardsBySellerIdTbVisitId(Long sellerId,List<Long> tbVisitIds);


    /**
     * 批量更新为已读
     * @param ids
     * @return
     */
    Integer updateAlreadyReadBatch(List<Long> ids);

    /**
     * 根据主键物理删除
     * 代理人演示专用
      * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);


    /**
     * 根据主键查找
     * @param ids
     * @return
     */
    List<UserForwardDto> findByIds(List<Long> ids);


    /**
     * 获取转发人数
     * @param param 查询参数
     * @return 转发人数
     */
    Integer countForwardNum(UserForwardQryParam param);

    /**
     * 根据条件查询去重的转发记录所对应的用户访问记录表id
     * @param param 查询条件
     * @return 去重的转发记录所对应的用户访问记录表id
     */
    List<Long> findDistinctVisitIdByParam(UserForwardQryParam param);
}
