package cn.com.duiba.kjy.api.util;

import cn.com.duiba.kjy.api.enums.WithdrawBizEnum;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;


/**
 * 提现时的业务单号生成器
 *
 * @author 吴文哲
 * @date 2019-10-31 14:06
 **/
public class BizIdMakerUtil {


    /**
     * 生成带业务含义的业务id
     *
     * @param id      自增id  可以使用idMakerClient.getBatchNextIDSequenced(IDMAKER_BIZID, BATCH_SIZE) 生成
     * @param bizEnum 提现业务枚举类
     * @return
     */
    public static String createBizId(Long id, WithdrawBizEnum bizEnum) {
        return bizEnum.getCode() + "_" + id;
    }

    /**
     * 业务单号是否属于某个活动
     *
     * @param bizId
     * @param bizEnum
     * @return
     */
    public static Boolean isBizIdBelongActivity(String bizId, WithdrawBizEnum bizEnum) {
        if (StringUtils.isBlank(bizId)) {
            return false;
        }
        String[] arr = bizId.split("_");
        if (arr.length < 2) {
            return false;
        }
        return Objects.equals(bizEnum.getCode(),Integer.valueOf(arr[0]));
    }
}
