package cn.com.duiba.kjy.api.enums.wx;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2020/10/16 2:31 下午
 */
@Getter
@AllArgsConstructor
public enum WxTagTypeEnum {

    LIVE_NON_VIP(1, "直播非VIP"),
    LIVE_VIP(2, "直播VIP"),
    LIVE(3, "直播"),
    KJJ(4, "客集集"),
    ZBXD(5, "国寿小程序"),
    ZBXD_KJJ(6, "客集集小程序"),
    ZBXD_LIVE(7, "国寿219直播间"),
    VOICE_LIVE(8,"语音直播权限并且无视频抽奖权限"),
    VIDEO_LOTTERY_LIVE(9,"视频抽取权限并且无语音直播权限"),
    VOICE_LIVE_AND_VIDEO_LOTTERY(10,"视频抽取权限并且语音直播权限"),
    VIP_RENEW_PUSH_TAG(11, "0414续费推文"),
    CPIC_SH_PUSH_TAG(12, "0428太保上分推文"),
    VIP_LESS_THAN_5_MONTHS(13, "0425VIP有效期不满5个月"),
    VIP_LESS_THAN_5_MONTHS_0603(14, "0603VIP有效期不满5个月"),
    GUIDE_CUSTOMER_ATTENTION(15, "用户引导"),
    VIP_RENEW_PUSH_TAG_AUGUST(16, "8月续费活动"),
	LIVE_SUMMARY(17, "直播汇总"),
    A_0_90(18, "9月续费-A"),
    B_0_90(19, "9月续费-B"),
    C_91_270(20, "9月续费-C"),
    RENEW_SEPTEMBER(21, "9月续费"),
    CORP_VERSION(22, "企业版标签"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    private static final Map<Integer, WxTagTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (WxTagTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static WxTagTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
