package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SellerDto;
import cn.com.duiba.kjy.api.dto.SellerUserDto;
import cn.com.duiba.kjy.api.dto.company.CompanyBindingSellerCountDto;
import cn.com.duiba.kjy.api.dto.seller.SellerAndRecordDto;
import cn.com.duiba.kjy.api.dto.seller.SellerIdAndNameAvatarDto;
import cn.com.duiba.kjy.api.dto.seller.SellerIdAndSellerNameDto;
import cn.com.duiba.kjy.api.dto.seller.SellerIdJudgeVipDto;
import cn.com.duiba.kjy.api.dto.seller.SidAndPhoneDto;
import cn.com.duiba.kjy.api.dto.seller.SidUidAndNameDto;
import cn.com.duiba.kjy.api.dto.seller.SidUidNameAndAvatarDto;
import cn.com.duiba.kjy.api.enums.seller.InternalSellerEnum;
import cn.com.duiba.kjy.api.enums.seller.SellerShowQrCodeTypeEnum;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchVipSellerParam;
import cn.com.duiba.kjy.api.params.SellerCardParam;
import cn.com.duiba.kjy.api.params.SellerSearchParam;
import cn.com.duiba.kjy.api.params.seller.VipCloseDetailParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteSellerService {

    /**
     * 通过id查询销售信息
     * @param param
     * @return
     */
    List<SellerDto> findByParam(SellerSearchParam param);

    /**
     * 通过id查询销售信息
     * @param param
     * @return
     */
    Integer countByParam(SellerSearchParam param);

    /**
     * 通过id查询销售信息
     * @param sellerId
     * @return
     */
    SellerDto findById(Long sellerId);

    /**
     * 根据用户ID查询
     * @param userId 用户ID
     * @return
     */
    SellerDto findByUserId(Long userId);

    /**
     * 判断销售是否满足续费条件
     * @param sellerId
     * @return
     */
    Boolean renewIdentity(Long sellerId);

    /**
     * 查询销售员列表
     * @param param
     * @return
     */
    Page<SellerDto> searchVipSellerList(SearchVipSellerParam param);

    SellerUserDto findSellerUserById(Long sellerId);

    /**
     *
     * @param dto
     * @return  0L 失败 其他为id
     */
    Long insert(SellerDto dto);

    Boolean update(SellerDto dto);

    /**
     * 批量更新代理人会员到期时间并记录
     * 企业版-公司授权有效期更新专用
     *
     * @param sellerAndRecordDtos 更新数据集合
     * @return 更新结果
     */
    int batchUpdateVipEndTimeAndRecord(List<SellerAndRecordDto> sellerAndRecordDtos);

    /**
     * 更新销售名片
     * @param param
     * @return
     */
    /**
     * 名片2.0 需求重构
     * @param param
     * @return
     */
    @Deprecated
    int editMyCard(SellerCardParam param);

    /**
     * 批量查询销售员信息
     * @param ids
     * @return
     */
    List<SellerDto> findByIds(List<Long> ids);

    /**
     * 当前公司关联的激活码绑定的用户数
     * @param companyIds
     * @return
     */
    List<CompanyBindingSellerCountDto> findCompanyBindingCount(List<Long> companyIds);

    /**
     * 根据公司ID获取销售员数
     * @param companyId
     * @return
     */
    int findCountByCompany(Long companyId);

    /**
     * 更新销售员公司信息
     * @param id
     * @param companyId
     * @return
     */
    Boolean updateCompany(Long id,  Long companyId);

    /**
     * 根据销售员ID获取公司ID
     * @param id
     * @return
     */
    Long findCompanyById(Long id);

    /**
     * 是否是付费开通会员
     * @param sellerId 销售员ID
     * @return true-是，false-不是
     */
    boolean isPayVip(Long sellerId);

    /**
     * 更新销售员展示二维码类型
     * @param typeEnum 展示二维码类型
     * @param id 销售员ID
     * @return 更新条数
     */
    int updateShowQrCodeTypeById(SellerShowQrCodeTypeEnum typeEnum, Long id);

    /**
     * 根据用户id列表查询代理人
     * @param userIds
     * @return
     */
    List<SellerDto> listByUserIds(List<Long> userIds);

    /**
     * 重置会员开始结束时间
     * @param sellerId
     * @return
     */
    Integer resetSellerVipDate(Long sellerId);

    /**
     * 获取某个公司下到所有sellerId
     * @param companyId
     * @return
     */
    List<Long> findIdsByCompanyId(Long companyId);

    /**
     * 根据userId 找到对应的SellerId集合
     * @param userIds
     * @return
     */
    List<Long> findSellerIdsByUserIds(List<Long> userIds);

    /**
     * 更新Seller的微信二维码
     * @param sellerId
     * @param wechatQrCode
     * @return
     */
    Boolean updateWechatQrCode(Long sellerId,String wechatQrCode);

    /**
     * 更新Seller的微信头像
     * @param sellerId
     * @param avatar
     * @return
     */
    Integer updateAvatar(Long sellerId,String avatar);

    /**
     * 获取有效会员的id
     * @return
     */
    List<Long> listValidVipIds(Integer offset, Integer pageSize);

    /**
     * 根据用户ID查询销售ID
     * @param userId
     * @return
     */
    Long findIdByUserId(Long userId);

    /**
     * 设置为内部销售人员
     * @param id
     * @param internalSeller
     * @see cn.com.duiba.kjy.api.enums.seller.InternalSellerEnum
     * @return
     */
    Boolean setInternalSeller(Long id, InternalSellerEnum internalSeller);

    /**
     * 根据销售ID集合查询销售名称
     * @param ids
     * @return
     */
    List<SellerIdAndSellerNameDto> findSellerNameByIds(List<Long> ids);

    /**
     * 根据用户ID查询销售的简单信息
     * @param ids
     * @return
     */
    List<SidUidAndNameDto> findSellerNameByUserIds(List<Long> ids);

    /**
     * 更新代理人来源
     * @param dto
     * @return
     */
    int updateSellerAccessSource(SellerDto dto);


    /**
     * 根据销售ID集合查询客判断是否是vip的参数
     * @param ids
     * @return
     */
    List<SellerIdJudgeVipDto>  finfSellerJudgeDtoByIds(List<Long> ids);


    /**
     * 获取代理人用户总数 缓存5分钟
     * @return
     */
    Integer getSellerTotalCount();


    /**
     * 根据代理人id获取名字
     * @param id
     * @return
     */
    String selectNameById(Long id);


    /**
     * 获取所有内部销售（缓存5分钟）
     * @return
     */
    List<SellerIdAndSellerNameDto>  getAllInnerSeller();
    /**
     * 根据代理人ID和销售名称查询
     * @param ids
     * @param sellerName
     * @return
     */
    List<SellerIdAndNameAvatarDto> findByIdsAndName(List<Long> ids, String sellerName);

    /**
     * 根据代理人ids查询
     * @param ids
     * @return
     */
    List<SidUidNameAndAvatarDto>findIdNameAvatarByIds(List<Long> ids);

    /**
     * 根据销售id获取所在的总公司id和行业id
     * @param sellerId
     * @return pair<总公司id,行业id>
     */
    Pair<Long,Long> getParentCompanyIdAndTradeIdBySellerId(Long sellerId);

    /**
     * 根据手机号获取销售的Id列表
     * @param phones
     * @return
     */
    Map<String,List<SidAndPhoneDto>>  findByPhones(List<String> phones);

    /**
     * 关闭vip功能
     * @param vipCloseParam
     * @return
     */
    Boolean closeVip(VipCloseDetailParam vipCloseParam);

    /**
     * 根据id更新代理人姓名
     *
     * @param dto 代理人id和姓名
     * @return 执行结果
     */
    int updateSellerName(SellerIdAndSellerNameDto dto);

    /**
     * 批量更新代理人姓名
     *
     * @param list 更新参数
     * @return 执行结果
     */
    int batchUpdateSellerName(List<SellerIdAndSellerNameDto> list);

    /**
     * 根据微信昵称和手机号查询sellerIds
     *
     * @param nickname 用户昵称
     * @param phoneNumber 手机号
     * @param pageSize 条数
     * @return sellerIds
     */
    List<Long> findIdsByNicknameAndPhoneNumber(String nickname, String phoneNumber, Integer pageSize);

    /**
     * 更新销售员名片二维码
     *
     * @param id        销售Id
     * @param qrCodeUrl 名片二维码Url
     * @return 执行结果
     */
    int updateSellerCardQrCode(Long id, String qrCodeUrl);

    /**
     * 根据手机号查询vip 只查询一个
     *
     * @param phoneNum 手机号
     * @return 销售信息
     */
    SellerDto findVipByPhoneNum(String phoneNum);
}
