package cn.com.duiba.kjy.api.dto.exclusive;

import lombok.Data;

import java.io.Serializable;

/**
 * 公司专区赠险
 *
 * @author ZhangJun
 * @date 2021/11/24 10:18 上午
 */
@Data
public class ExclusiveInsuranceDto implements Serializable {

    private static final long serialVersionUID = -5883894525933474978L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 赠险类型
     */
    private Integer insuranceType;

    /**
     * 赠险名称
     */
    private String insuranceName;

    /**
     * 赠险封面图片
     */
    private String insuranceImgUrl;

    /**
     * 赠险保额
     */
    private Long insuranceAmount;

    /**
     * 赠险描述
     */
    private String insuranceDesc;

    /**
     * 赠险产品链接
     */
    private String insuranceLink;

    /**
     * 赠险状态
     * {@link cn.com.duiba.kjy.api.enums.exclusive.ExclusiveInsuranceStatusEnum}
     */
    private Integer insuranceStatus;

}
