package cn.com.duiba.kjy.api.params.appvideo;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2021-08-10 10:52
 * 视频模板统计参数
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AppVideoTemplateSearchParam extends PageQuery {

    private static final long serialVersionUID = 1770964951235558603L;

    /**
     * 栏目id
     */
    private Long classificationId;

    /**
     * 视频类型
     * @see cn.com.duiba.kjy.api.enums.appvideo.AppVideoTemplateTypeEnum
     * @deprecated 此属性已经移动到子类中，未来将删除此属性，目前部分接口已经不支持此属性
     */
    @Deprecated
    private List<Integer> videoTypeList;
}
