package cn.com.duiba.kjy.api.params.corp;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zhanghuifeng
 * @date 2021/10/28 17:06
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CorpImportTaskParam extends PageQuery {
    private static final long serialVersionUID = -1446479209978489477L;

    /**
     * 任务类型，1-员工名单导入
     * @see cn.com.duiba.kjy.api.enums.corp.CorpImportTypeEnum
     */
    private Integer taskType;

    /**
     * 任务状态 0-初始化 1-导入中 2-导入失败(系统报错) 3-导入完成
     * @see cn.com.duiba.kjy.api.enums.corp.CorpImportTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 业务ID
     */
    private Long bizId;
}
