package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.corp.CorpStaffDto;
import cn.com.duiba.kjy.api.dto.corp.StaffTypeDto;
import cn.com.duiba.kjy.api.params.corp.QueryStaffListParam;
import cn.com.duiba.kjy.api.params.corp.StaffPageParam;

import java.util.List;

/**
 * 企业后台管理-公司管理-员工管理
 * @author zhanghuifeng
 * @date 2021/8/24 17:30
 */
@AdvancedFeignClient
public interface RemoteCorpStaffService {

    /**
     * 新增员工信息
     *
     * @param dto 员工信息
     * @return 新增的条数
     */
    Boolean save(CorpStaffDto dto);

    /**
     * 更新员工信息
     *
     * @param dto 员工信息
     * @return 更新影响的条数
     */
    Boolean update(CorpStaffDto dto);

    /**
     * 删除员工
     *
     * @param id 员工信息主键
     * @return 删除的条数
     */
    Boolean deleteById(Long id);

    /**
     * 根据主键id查询员工信息
     * @param id 主键id
     * @return 员工信息
     */
    CorpStaffDto findById(Long id);

    /**
     * 根据id批量查询
     *
     * @param ids 主键id集合
     * @return 查询结果
     */
    List<CorpStaffDto> listByIds(List<Long> ids);

    /**
     * 根据公司id+手机号查询员工
     *
     * @param companyId  公司id
     * @param phone 员工手机号
     * @return 员工信息
     */
    CorpStaffDto findByCompanyIdAndPhone(Long companyId, String phone);

    /**
     * 查询员工列表
     *
     * @param param 列表查询参数
     * @return 员工列表
     */
    List<CorpStaffDto> list(QueryStaffListParam param);

    /**
     * 查询所有员工类型
     *
     * @return 员工类型列表
     */
    List<StaffTypeDto> listStaffType();

    /**
     * 根据管理员手机号查询
     * @param staffPhone 手机号
     * @return 管理员列表
     */
    List<CorpStaffDto> listByPhone(String staffPhone);

    /**
     * 分页查询管理员列表（后台专用）
     * @param param 分页参数
     * @return 管理员列表
     */
    List<CorpStaffDto> page4backend(StaffPageParam param);

    /**
     * 分页查询管理员总数（后台专用）
     * @param param 查询参数
     * @return 条数
     */
    int count4backend(StaffPageParam param);

    /**
     * 删除营业部管理员与营业部的关联关系
     * @param deptId 营业部id
     * @return 是否成功
     */
    boolean deleteStaffDeptRelation(Long deptId);
}
