package cn.com.duiba.kjy.api.remoteservice.corp;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.pub.PubUserCustomerStatDto;

import java.util.List;

/**
 * 公共空间-客户统计
 *
 * @author xuzhigang
 * @date 2021/11/1 2:20 下午
 **/
@AdvancedFeignClient
public interface RemotePubUserCustomerStatService {

    /**
     * 根据客户id批量查询
     *
     * @param userId 用户id
     * @param customerUserIds 客户用户id集合
     * @return 客户统计信息
     */
    List<PubUserCustomerStatDto> findByCustomerUserIds(Long userId, List<Long> customerUserIds);

    /**
     * ！！！刷数据用
     * 批量新增或更新观看直播数
     * 覆盖统计数据
     *
     * @param list 统计信息
     * @return 执行结果
     */
    int batchInsertOrUpdateLiveViewCount(List<PubUserCustomerStatDto> list);

    /**
     * ！！！增量数据
     * 批量新增或增加观看直播数
     * 累加统计数据
     *
     * @param list 统计信息
     * @return 执行结果
     */
    int batchInsertOrIncreaseLiveViewCount(List<PubUserCustomerStatDto> list);

    /**
     * ！！！刷数据用
     * 批量新增或更新累计访问数
     * 覆盖统计数据
     *
     * @param list 统计信息
     * @return 执行结果
     */
    int batchInsertOrUpdateVisitCount(List<PubUserCustomerStatDto> list);

    /**
     * ！！！增量数据
     * 批量新增或增加累计访问数
     * 累加统计数据
     *
     * @param list 统计信息
     * @return 执行结果
     */
    int batchInsertOrIncreaseVisitCount(List<PubUserCustomerStatDto> list);
}