package cn.com.duiba.kjy.api.dto.corp;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企业版-导入任务表
 * @author kjj mybatis generator 
 * 2021-10-28
 */
@Data
public class CorpImportTaskDto implements Serializable {
    private static final long serialVersionUID = 16354116094763L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *任务类型，1-员工名单导入
     * not null default = 1
     */
    private Integer taskType;

    /**
     *
     *任务状态 0-初始化 1-导入中 2-导入失败(系统报错) 3-导入完成
     * not null default = 0
     */
    private Integer taskStatus;

    /**
     *
     *业务id
     * not null default = 0
     */
    private Long bizId;

    /**
     *
     *文件名称
     * max length = 255
     * not null default = 
     */
    private String fileName;

    /**
     *
     *导入总数
     * not null default = 0
     */
    private Integer importCount;

    /**
     *
     *导入成功数量
     * not null default = 0
     */
    private Integer successCount;

    /**
     *
     *导入失败数量
     * not null default = 0
     */
    private Integer failureCount;

    /**
     *
     *导入源文件
     * max length = 100
     * not null default = 
     */
    private String importExcelUrl;

    /**
     *
     *导入失败文件
     * max length = 100
     * not null default = 
     */
    private String failureExcelUrl;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}