package cn.com.duiba.kjy.api.dto.dailypostersconfig;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 每日唤醒推送海报配置
 * @author kjj mybatis generator 
 * 2020-06-16
 */
@Data
public class DailyPostersConfigDto implements Serializable {
    private static final long serialVersionUID = 15922881905766165L;

    /**
     *
     *主键ID
     * not null default = null
     */
    private Long id;

    /**
     *
     *推送时间
     * not null default = null
     */
    private Date pushTime;

    /**
     *
     *图片配置：大图
     * max length = 512
     * not null default = null
     */
    private String imageUrlConfig;

    /**
     *
     *公众号media_id配置信息
     * max length = 512
     */
    private String mediaConfig;

    /**
     *
     *推送文案
     * max length = 512
     */
    private String pushContent;
    /**
     * 图片文案
     */
    private String imgContent;

    /**
     *
     *配置类型
     * @see cn.com.duiba.kjy.api.enums.dailyPosters.DailyPostersConfigTypeEnum
     *
     */
    private Integer configType;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *修改时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}