package cn.com.duiba.kjy.api.dto.push;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 自定义推送消息表
 * @author kjj mybatis generator 
 * 2020-07-24
 */
@Data
public class CustomPushMsgDto implements Serializable {
    private static final long serialVersionUID = 15955716759089352L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *推送记录ID
     * not null default = null
     */
    private Long pushManagerId;

    /**
     *
     *模板消息配置ID
     */
    private Long messageConfigId;

    /**
     *
     *图片消息的微信返回的ID
     * max length = 255
     */
    private String picMediaId;

    /**
     *
     *模版消息跳转URL
     * max length = 255
     */
    private String templateUrl;

    /**
     *
     *模版消息内容的json
     * max length = 800
     */
    private String templateJson;

    /**
     *
     *客服文字消息的内容
     * max length = 800
     */
    private String customWords;

    /**
     *
     *小程序卡片消息的小程序ID
     */
    private Long mpId;

    /**
     *
     *小程序卡片消息标题
     * max length = 50
     */
    private String cardTitle;

    /**
     *
     *小程序卡片跳转地址
     * max length = 255
     */
    private String cardPath;

    /**
     *
     *小程序卡片消息image
     * max length = 255
     */
    private String cardImage;

    /**
     * 缩略图
     */
    private String thumbnail;

    /**
     *
     *卡片描述
     * max length = 255
     */
    private String cardDesc;

    /**
     *
     *内容id，文章、海报、活动ID等等
     */
    private Long itemId;

    /**
     *
     *类型; activity =活动、article =文章、daily =日报
     * max length = 32
     */
    private String itemType;

    /**
     *
     *当前消息的发送顺序 从0开始递增
     */
    private Integer msgSort;

    /**
     *
     *1:模版消息，2:客服文字消息 3:客服图文消息（卡片） 4:客服图片消息
     * not null default = 1
     */
    private Integer messageType;

    /**
     * 消息唯一标识
     * @see cn.com.duiba.kjy.api.api.enums.MessageMarkEnum
     */
    private Integer messageMark;


    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}