package cn.com.duiba.kjy.api.enums.corp;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 企业后台-业务类型枚举
 *
 * @author ZhangJun
 * @date 2021/10/27 1:40 下午
 */
@Getter
@AllArgsConstructor
public enum CorpCompanyBizTypeEnum {

    CUSTOMER_ASSISTANT(1, "集客助手", true),
    LIVE(2, "直播", true),
    AI_VIDEO(3, "跟拍助手", false),
    ;

    /**
     * 业务类型
     */
    private Integer bizType;

    /**
     * 类型说明
     */
    private String desc;

    /**
     * 该业务类型是否关联公司
     */
    private boolean linkCompany;


    private static final Map<Integer, CorpCompanyBizTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CorpCompanyBizTypeEnum::getBizType, Function.identity())));
    }

    public static CorpCompanyBizTypeEnum getByType(Integer bizType) {
        if (Objects.isNull(bizType)) {
            return null;
        }

        return ENUM_MAP.get(bizType);
    }


}
