package cn.com.duiba.kjy.api.params.explosionContent;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 爆款素材查询参数
 * @author 吴文哲
 * @date 2020-05-21 18:03
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class ExplosionQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 4554189025497083264L;

    /**
     * 是否为热文
     */
    private Integer isHotContent;

    /**
     * 爆款素材类型
     * @see cn.com.duiba.kjy.api.enums.explosioncontent.ExplosionContentTypeEnum
     */
    private Integer type;

    /**
     * 素材类型
     * @see cn.com.duiba.kjy.api.constant.ContentTypeEnum
     */
    private String contentType;

}
