package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ProductDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchProductParam;

import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2019-02-13 15:02
 * @description: 管理端产品描述
 */
@AdvancedFeignClient
public interface RemoteProductService {

    /**
     * 保存意向产品
     *
     * @param productDto
     * @return
     */
    Long save(ProductDto productDto);

    /**
     * 编辑意向产品
     *
     * @param productDto
     * @return
     */
    Integer edit(ProductDto productDto);

    /**
     * 查询产品列表
     * @param param
     * @return
     */
    Page<ProductDto> searchProductList(SearchProductParam param);

    /**
     * 删除意向产品
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 通过id列表批量查询产品
     * @param ids
     * @return
     */
    List<ProductDto> findByIds(List<Long> ids);

}
