package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.PromotionCodeBatchExtDto;

/**
 * 优惠码批次扩展表
 * @author xuzhigang
 */
@AdvancedFeignClient
public interface RemotePromotionCodeBatchExtService {

    /**
     * 保存优惠码批次扩展信息
     * @param promotionCodeBatchExtDto 优惠码扩展表
     * @return 执行结果
     */
	int save(PromotionCodeBatchExtDto promotionCodeBatchExtDto);

    /**
     * 根据优惠码批次id查询打卡规则id
     * @param promotionBatchId 优惠码批次id
     * @return 打卡规则配置id
     */
    Long getClockInConfIdByPromotionBatchId(Long promotionBatchId);
}
