package cn.com.duiba.kjy.api.remoteservice.timingLottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.timingLottery.TimingLotteryRecordDto;
import cn.com.duiba.kjy.api.params.timingLottery.TimingLotteryListParam;
import cn.com.duiba.kjy.api.params.timingLottery.TimingLotteryRecordParam;

import java.util.List;
import java.util.Map;

/**
 * Service
 *
 * @author xiaotian
 * 2021-1-6 10:12:08
 */
@AdvancedFeignClient
public interface RemoteTimingLotteryRecordService {
    /**
     * 新增记录
     */
    Boolean save(TimingLotteryRecordDto dto);

    /**
     * 根据id删除
     */
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    Boolean updateById(TimingLotteryRecordDto dto);

    /**
     * 根据id获取
     */
    TimingLotteryRecordDto getById(Long id);

    /**
     * 获取中奖列表
     *
     * @param configId
     * @return
     */
    List<Long> getWinner(Long configId);

    /**
     * 更新中奖人员
     *
     * @param configId
     * @param ids
     * @return
     */
    boolean updateWinner(Long configId, List<Long> ids);

    /**
     * 筛选列表
     *
     * @param timingLotteryRecordParam
     * @return
     */
    List<TimingLotteryRecordDto> getRecordList(TimingLotteryRecordParam timingLotteryRecordParam);

    /**
     * 筛选访客参与的记录
     *
     * @param configId 抽奖Id
     * @param visitId  访客Id
     * @return
     */
    List<TimingLotteryRecordDto> getVisitRecord(Long configId, Long visitId);


    /**
     * 筛选助力记录
     *
     * @param configId   抽奖Id
     * @param fromUserId 需要助力的访客Id
     * @return
     */
    List<TimingLotteryRecordDto> getHelpRecord(Long configId, Long fromUserId);


    /**
     * 筛选助力记录(访客帮谁助力过)
     *
     * @param configId   抽奖Id
     * @return
     */
    Map<Long,List<TimingLotteryRecordDto>> getHelpRecordList(Long configId, List<Long> visitId);

    /**
     * 筛选列表数量
     *
     * @param timingLotteryRecordParam
     * @return
     */
    Integer getRecordListCount(TimingLotteryRecordParam timingLotteryRecordParam);

}
