package cn.com.duiba.kjy.api.remoteservice.usercommitrecord;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.usercommitrecord.UserCommitRecordDto;
import cn.com.duiba.kjy.api.dto.usercommitrecord.UserCommitRecordSimpleDto;

import java.util.List;

/**
 * @Author chentiecheng
 * @Date 2020/2/7 11:26 上午
 */
@AdvancedFeignClient
public interface RemoteUserCommitRecordService {

    /**
     * 根据用户id和销售id查询用户是否存在提交记录
     * @param userId
     * @param sellerId
     * @return
     */
    Boolean isExistCommitRecord(Long userId,Long sellerId);

    /**
     * 新增提交记录
     * @param userCommitRecordDto
     * @return
     */
    Boolean insert(UserCommitRecordDto userCommitRecordDto);

    /**
     * 新增提交记录  代理人演示专用
     * @param userCommitRecordDto
     * @return
     */
    Long insert4SellerDemo(UserCommitRecordDto userCommitRecordDto);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    UserCommitRecordDto findById(Long id);

    /**
     * 根据主键删除
     * @param ids
     * @return
     */
    Integer deleteByIds(List<Long> ids);

    /**
     * 根据访问记录ids查询记录
     * @param visitTableIds
     * @return
     */
    List<UserCommitRecordSimpleDto> listSimpleDtosByVisitTableIds(List<Long> visitTableIds);
}
