package cn.com.duiba.kjy.api.enums.bank.direct.red;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2021/12/21 10:21
 * @description 直接发红包 - 领取状态枚举
 */
@Getter
@AllArgsConstructor
public enum DirectRedReceiveStatus {

    TO_RECEIVE(1, "待领取"),
    RECEIVING(2, "领取中"),
    SUCCESS(3, "领取成功"),
    FAIL(4, "领取失败"),
    OUT_OF_DATE(5, "过期"),
    ;

    private static final Map<Integer, DirectRedReceiveStatus> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(DirectRedReceiveStatus::getStatus, Function.identity()))
    );

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据状态获取枚举
     */
    public static DirectRedReceiveStatus getByType(Integer type) {
        return ENUM_MAP.get(type);
    }

}

