package cn.com.duiba.kjy.api.remoteservice.layer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.layer.LayerConfigExtDto;
import cn.com.duiba.kjy.api.params.layer.LayerConfigExtEditParam;
import cn.com.duiba.kjy.api.params.layer.LayerConfigExtParam;

import java.util.List;

/**
 * 弹层配置拓展信息rpc服务
 * @author 吴文哲
 * @date 2020-03-25 18:48
 **/
@AdvancedFeignClient
public interface RemoteLayerConfigExtService {

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    LayerConfigExtDto findById(Long id);

    /**
     * 根据id 查找列表
     * @param ids
     * @return
     */
    List<LayerConfigExtDto> findByIds(List<Long> ids);

    /**
     * 插入拓展信息
     * @param param
     * @return
     */
    Long insertExt(LayerConfigExtEditParam param);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<LayerConfigExtDto> findByCondition(LayerConfigExtParam param);
}
