package cn.com.duiba.kjy.livecenter.api.param.red;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播配置-红包相关配置
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveConfRedPacketSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15858153190848902L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 红包类型：1-开播，2-发红包
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketTypeEnum
     */
    private Integer redType;

    /**
     * 红包状态：1-未开始，2-可领取，3-领取结束
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketStatusEnum
     */
    private Integer redStatus;

    /**
     * 红包状态集合
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveRedPacketStatusEnum
     */
    private List<Integer> redStatusList;
}